@extends('user')
@section('style')
@stop

@section('content')
    @include('partials.breadcrumb')


    <div class="container pt-5 pb-5">
        <div class="card">
            <div class="card-header bg-info">
                <h3>@lang('Make Withdraw')</h3>
            </div>
            <div class="card-body">
                <form action="{{route('withdraw.request')}}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            @include('errors.error')
                            @if (session('whoops'))
                                <div class="alert alert-danger alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                    {!!  __(session('whoops')) !!}
                                </div>
                            @endif
                            @if (session('ok'))
                                <div class="alert alert-success alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                    {!!  __(session('ok')) !!}
                                </div>
                            @endif
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="balance">@lang('Balance')</label>
                                <input type="text" class="form-control form-control-lg" name="current_balance" value="{{ Auth::user()->balance }}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="balance">@lang('Withdraw Methods')</label>
                                <select name="withdraw_method_id" id="receive_currency_id" class="form-control form-control-lg receive">
                                    <option disabled selected>@lang('Select')</option>
                                    @foreach ($withdraw_methods as $data)
                                        <option value="{{ $data->id }}">{{ $data->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="balance">@lang('Enter Withdraw Amount')</label>
                                <div class="input-group mb-2">
                                    <input class="form-control form-control-lg" type="text" id="sendMan" name="withdraw_amount" value="1" >
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">{{ $basic->currency }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="receive"> @lang('You Receive')</label>
                                <input type="text" class="form-control form-control-lg" name="receive" id="receiveMan" value="1" readonly>
                            </div>
                        </div>

                        <div class="col-md-12 text-center mt-4">
                            <div class="form-group">
                                <button type="submit" class="btn btn-success btn-block btn-lg"> @lang('Withdraw') </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        $("#withdrawls").addClass("active");

    </script>
@endsection


@section('js')
    <script>

        $(document).ready(function(){

            var receiverId = $(".receive").val();
            var withdrawamount = $("#sendMan").val();



            $('.receive').on('change', function(){

                var receiverId = $(".receive").val();
                var sendingAmount = $("#sendMan").val();
                ajaxReq(receiverId,sendingAmount);

            });



            $('#sendMan').keyup( function(){


                var receiverId = $(".receive").val();
                var sendingAmount = $("#sendMan").val();
                if($(this).val() > 0){
                    ajaxReq(receiverId,sendingAmount);

                }else{
                    alert('Please Insert Valid Number')
                    $('#sendMan').val(1)

                    var receiverId = $(".receive").val();
                    var sendingAmount = $("#sendMan").val();
                    ajaxReq(receiverId,sendingAmount);
                }


            });

            function ajaxReq(receiverId,sendingAmount){

                $.ajax({
                    url: "{{route('get.withdrawRate')}}",
                    type: "get",
                    data: {
                        'receiverId' : receiverId,
                        'sendingAmount' : sendingAmount,
                    } ,
                    success: function (response) {
                        $('#receiveMan').val(response)
                        console.log(response)
                    }
                });
            }




        })

    </script>
@endsection
